'PWM-based Temperature-controlled Fan
'Bascom-Avr IDE [2.0.7.5]
'Flash used 2368 Bytes
'Author: Mahmood Alimohammadi
'Date: July 30, 2016
'*******************************************************************************

$regfile = "m48pdef.dat"
$crystal = 1000000

Config Lcd = 16 * 2
Config Lcdpin = Pin , Db4 = Portd.0 , Db5 = Portd.1 , Db6 = Portd.2 , Db7 = Portd.3 , Rs = Portd.6 , E = Portd.7

Config Adc = Single , Prescaler = Auto , Reference = Avcc

Config Timer1 = Pwm , Pwm = 10 , Prescale = 1 , Compare A Pwm = Clear Up , Compare B Pwm = Clear Down

Dim Temp As Word , Temp_pause As Byte , Cls_pause As Byte , Degree As Word , Fan_set As Word , Alarm_set As Word , I As Byte
Dim Down_timer As Word , Down_timer2 As Word , Eep_fan As Eram Word , Eep_alarm As Eram Word , Speed As Byte

Deflcdchar 1 , 32 , 32 , 14 , 31 , 31 , 31 , 14 , 4         'Heart symbol ,life signal
Deflcdchar 2 , 32 , 32 , 32 , 32 , 32 , 32 , 32 , 32        'Blank

Config Pinb.3 = Input
Config Pinb.4 = Input
Config Pinb.6 = Input
Config Pinb.7 = Input

Portb.3 = 1                                                 'Activate pullup resistor.
Portb.4 = 1                                                 'Activate pullup resistor.
Portb.6 = 1                                                 'Activate pullup resistor.
Portb.7 = 1                                                 'Activate pullup resistor.
'*******************************************************************************

Pwm1a = 0                                                   'Fan output
Pwm1b = 0                                                   'Initial LED fade out and Alarm LED Flash
Down_timer = 0
Speed = 0
Cls_pause = 0
Temp_pause = 0
Degree = 0
I = 0
'*******************************************************************************

'Welcome message
Cls
Cursor Off
Upperline
Lcd "Temperature-"                                          'Message on for 3 seconds
Lowerline
Lcd "Controlled Fan"

Do
Incr Pwm1b                                                  'LED fades out in 3 seconds.
Waitms 3
Loop Until Pwm1b = 1023
'*******************************************************************************

Start Adc

Do

Select Case Temp_pause                                      '10-second delay to show the temperature

Case 1 To 100
Decr Temp_pause
'*******************************************************************************

'Temperature, fan and alarm settings and saving

Case Is = 0
Temp = Getadc(5)                                            'LM35 output voltage is fed to the  input pin ADC5(pin28).
Temp = Temp / 2
Temp_pause = 100
End Select

Fan_set = Getadc(4)                                         'Input pin ADC4(pin27) for VR2 to set the fan-temperature
Fan_set = Fan_set / 10

If Pinb.3 = 0 Then Eep_fan = Fan_set                        'Write the fan-setting to the EEPROM.
If Pinb.3 = 1 Then
Fan_set = 0
Fan_set = Eep_fan                                           'Read the fan-setting from the EEPROM.
End If

'ADC4 (pin27) is used for both the fan and alarm settings.
Alarm_set = Getadc(4)
Alarm_set = Alarm_set / 10

If Pinb.4 = 0 Then Eep_alarm = Alarm_set                    'Write the  alarm-setting to the EEPROM.
If Pinb.4 = 1 Then
Alarm_set = 0
Alarm_set = Eep_alarm                                       'Read the alarm-setting from the EEPROM.
End If

If Fan_set >= 100 Then Fan_set = 100                        'Max temperature-setting for fan
If Alarm_set >= 100 Then Alarm_set = 100                    'Max temperature-setting for alarm
'*******************************************************************************

'60 seconds delay to stop the fan when the temperature drops
'below the fan set-point declared by the user.

Select Case Down_timer
Case 1 To 600
Decr Down_timer

Case Is = 0
If Temp <= Fan_set Then
Pwm1a = 0
Speed = 0
End If
End Select

'*******************************************************************************

'Setting the modes of speeds

If Temp > Fan_set Then
Degree = Temp - Fan_set
Speed = Degree
Down_timer = 600                                            'Down-timer resets to 60 seconds.

If Pinb.6 = 0 Then                                          '10-step speed of the fan
Degree = Degree * 100
If Speed >= 10 Then Speed = 10
End If

If Pinb.6 = 1 Then                                          '5-step speed of the fan
If Pinb.7 = 1 Then
Degree = Degree * 200
If Speed >= 5 Then Speed = 5
End If

If Pinb.7 = 0 Then                                          '3-step speed of the fan
Degree = Degree * 341                                       '1023/341=3
If Speed >= 3 Then Speed = 3
End If
End If

If Degree >= 1023 Then Degree = 1023                        'Max.step for pwm1a
Pwm1a = Degree
End If

 '*******************************************************************************

'5-second delay to clear screen and eliminate its blinking

Select Case Cls_pause
Case 1 To 50
Decr Cls_pause

Case Is = 0
Cls

Locate 1 , 1
Lcd "T:" ; Temp ; "C"
Cls_pause = 50
End Select

Locate 1 , 8
Lcd "A:" ; Alarm_set ; "C" ; "    "

Locate 1 , 15
Down_timer2 = Down_timer / 10
Lcd Down_timer2 ; "  "

Locate 2 , 1
Lcd "F:" ; Fan_set ; "C" ; "    "

Locate 2 , 12
Lcd "Sp:" ; Speed ; "     "

'Heart symbol to appear and blink on the screen as life signal

 If I = 0 Then I = 10
 Decr I
 If I = 5 Then
 Locate 2 , 8
 Lcd Chr(1)                                                 'Heart symbol
 Elseif I = 0 Then
 Locate 2 , 8
 Lcd Chr(2)                                                 'Blank
 End If
'*******************************************************************************

'Alarm mode

If Temp >= Alarm_set Then                                   'LED1 flashes in alarm mode
Pwm1b = 0
End If

Waitms 50

Pwm1b = 1023
Loop
End